@extends($activeTemplate.'layouts.master')
@section('content')

<div class="information-foot navbar-foot">
    <div class="user-top">
        <div class="user-head">
            <div class="user-avatar">
                <img src="{{ asset(getImage(getFilePath('logoIcon').'/logo_2.png')) }}">
            </div>
            <div class="user-info">
                <div class="user-item">ID: Good</div>
                <div class="user-item">+91 {{ auth()->user()->username }}</div>
            </div>
            <div class="user-income">
                <div class="user-income-item">
                    <span>{{ showAmount(auth()->user()->successfulWithdrawals) }} {{ $general->cur_text }}</span>
                    <label>Total Withdraw</label>
                </div>
                <div class="user-income-item">
                    <span>{{ showAmount(auth()->user()->deposit_wallet) }}{{ $general->cur_text }}</span>
                    <label>Recharge Income</label>
                </div>
                <div class="user-income-item">
                    <span>{{ showAmount(auth()->user()->interest_wallet) }}{{ $general->cur_text }}</span>
                    <label>Total Income</label>
                </div>
            </div>
        </div>
        <div class="user-con">
            <div class="user-money">
                <div class="user-money-item">
                    <div class="user-cash">
                        <span>{{ showAmount(auth()->user()->interest_wallet) }}{{ $general->cur_text }}</span>
                        <span>Total Income</span>
                    </div>
                    <div class="user-cash">
                        <span>{{ showAmount(auth()->user()->interest_wallet) }}{{ $general->cur_text }}</span>
                        <span>Current Balance</span>
                    </div>
                </div>
                <div class="user-money-item">
                    <div class="money-btn">
                        <a href="{{route ('user.deposit.index')}}">
                            <span>Recharge</span>
                        </a>
                        <a href="{{route ('user.withdraw')}}">
                            <span>Withdraw</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="user-nav">
        <ul>
            <li>
                <a href="{{ route('user.profile.setting') }}">
                    <i><img src="{{asset ('core/img/icon_50.png')}}"></i>
                    <span>Account</span>
                    <i><img src="{{asset ('core/img/fh.png')}}"></i>
                </a>
            </li>
            <li>
                <a href="{{route ('user.withdraw.history')}}">
                    <i><img src="{{asset ('core/img/icon_51.png')}}"></i>
                    <span>withdraw Records</span>
                    <i><img src="{{asset ('core/img/fh.png')}}"></i>
                </a>
            </li>
            <li>
                <a href="{{route ('user.deposit.history')}}">
                    <i><img src="{{asset ('core/img/icon_52.png')}}"></i>
                    <span>Recharge Record</span>
                    <i><img src="{{asset ('core/img/fh.png')}}"></i>
                </a>
            </li>
            <li>
                <a href="{{route ('user.invest.log')}}">
                    <i><img src="{{asset ('core/img/icon_53.png')}}"></i>
                    <span>Income</span>
                    <i><img src="{{asset ('core/img/fh.png')}}"></i>
                </a>
            </li>
            <li>
                <a href="{{ route('user.change.password') }}">
                    <i><img src="{{asset ('core/img/icon_56.png')}}"></i>
                    <span>Password</span>
                    <i><img src="{{asset ('core/img/fh.png')}}"></i>
                </a>
            </li>
            <li>
                <a href="https://wa.me/+923042324661" target="_blank">
                    
                    <i><img src="{{asset ('core/img/icon_57.png')}}"></i>
                    <span>Contact Devlopers</span>
                    <i><img src="{{asset ('core/img/fh.png')}}"></i>
                </a>
            </li>
     
            <li>
                <a href="">
                    <i><img src="{{asset ('core/img/icon_58.png')}}"></i>
                    <span>APP Download</span>
                    <i><img src="{{asset ('core/img/fh.png')}}"></i>
                </a>
            </li>
        </ul>
    </div>
    <div class="user-btn">
        <a href="{{route ('user.logout')}}">Logout</a>
    </div>
</div>
@endsection


@push('script')
    <script>
        (function($){
            "use strict";
            $('#copyBoard').click(function(){
                var copyText = document.getElementsByClassName("copyURL");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                /*For mobile devices*/
                document.execCommand("copy");
                $('.copyText').text('Copied');
                setTimeout(() => {
                    $('.copyText').text('Copy');
                }, 2000);
            });
        })(jQuery);
    </script>
@endpush
